#version 330
#extension GL_EXT_gpu_shader4 : enable
//Complex Function GraphMod01.fsh  by  amhall

//https://www.shadertoy.com/view/ttlyzf
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by Anthony Hall, June 2020

const float pi = radians(180.0);
const int SUPERSAMPLE = 3; // Decrease to speed things up, increase to reduce aliasing
const int samples = SUPERSAMPLE * SUPERSAMPLE;
const float increment = 1.0 / float(SUPERSAMPLE);
const float offset = increment / 2.0 - 0.5;

// By default, the graph is such that the minimum screen dimension
// corresponds to [-1.0, 1.0]
// Change this vector to change the scale of the real and imaginary axes respectively
const vec2 SCALE = vec2(4.0, 4.0);

// This is the coordinate of the graph that corresponds to
// the center of the screen
const vec2 CENTER = vec2(0.0, 0.0);

// Scale the speed with which the hue shifts with time
// At 1.0, it cycles every 6 seconds
const float colorShift = 1.0;

// Scale the speed with which the layer effect shifts with time
// At 1.0, it cycles every 2 seconds
const float layerShift = 1.0;

// The intensity of the magnitude-based layer effect
const float layerIntensity = 0.5;

// *** These are the complex operations available! ***

// Multiplies two complex numbers, c1 * c2
vec2 complexMultiply(vec2 c1, vec2 c2);

// Divides two complex numbers, c1 / c2
vec2 complexDivide(vec2 c1, vec2 c2);

// Divides a float by a complex number, f / c
vec2 complexDivide(float f, vec2 c);

// Takes the natural logarithm of a complex number, ln(c)
vec2 complexLog(vec2 c);

// Raises e to a complex power, e^c
vec2 complexExp(vec2 c);

// Raises a complex number to a complex power, c^exponent
vec2 complexPow(vec2 c, vec2 exponent);

// Sine of a complex number
vec2 complexSin(vec2 c);

// Cosine of a complex number
vec2 complexCos(vec2 c);

// Tangent of a complex number
vec2 complexTan(vec2 c);

// *** This is the function that we are graphing ***
// The input and output are both complex numbers
vec2 f(vec2 z)
{
    // sin(cos(tan(z))), offset, rotated, and scaled
    z /= 1.6; return complexSin(complexCos(complexTan((z.yx / 6.0) + vec2(4.7, 0.0)))); 
    
    // Here are some of my other favorites:    
    
	// Mandelbrot - Append '*/' to next line to uncomment
    /* 
    z = z / 3.7 - vec2(0.6, 0.0);
    vec2 C = z;
    for (int i = 0; i < 22; i++) 
        z = complexMultiply(z, z) + C;
    
    return z;
    /**/
    
    // Julia, travelling around main cardioid
    // It takes a lot of iterations to get good detail on the spirals
    // so it is a good idea to reduce the supersampling (see top)
    // Append '*/' to the next line to uncomment
    /* 
	z = z / 3.0;// - vec2(0.6, 0.0);
    
    float time = iTime / 32.0;
    vec2 C = vec2(cos(time), sin(time))/2.0 - vec2(cos(time * 2.0), sin(time * 2.0))/4.; 
    
    for (int i = 0; i < 100; i++) 
        z = complexMultiply(z, z) + C;
    
    return z * 1.3; // Brighten the coloring a bit
    /**/
    
    // cos(sin(sin(z)))
    // return complexCos(complexSin(complexSin(z)));
    
    // e^sin( (z+1)/z ), scaled 
    // z /= 5.0; return complexExp(complexSin(complexDivide(z + 1.0, z)));
    
    // 2 sin(time) / (z*(z + <cos(time), sin(time)>)) yields a cool orbit effect
    // z /= 2.0; return 2.0 * complexDivide(sin(iTime), complexMultiply(z, z + vec2(cos(iTime), sin(iTime)))); 
}

// Interpolates t as a percentage between a and b
// t is clamped between 0 and 1
float reverseLerp(float t, float a, float b) {
    float p = (t - a) / (b - a);
    return clamp(p, 0.0, 1.0);
}

// Gets a generic color wheel value given an angle
// Theta is in degrees
float colorWheelValue(float theta) {
    theta = mod(theta - 60.0 * colorShift * iTime, 360.0);
    
    if (theta < 180.0)
        return reverseLerp(theta, 120.0, 180.0);
    else
        return reverseLerp(theta, 360.0, 300.0);
}

// Converts a complex point to its place on the color wheel
vec3 getColorFromPoint(vec2 point) {
    // Uncomment this line to sample a texture instead of coloring normally
    // return texture(iChannel0, point / 20.0 + iTime / 50.0).xyz;
    
    // Make infinity, nan and x = 0 black (so atan doesnt divide by 0)
    if (isinf(point.x) || isinf(point.y) ||
        isnan(point.x) || isnan(point.y) ||
        point.x == 0.0)
        
        return vec3(0.0);
    
    // Solve for angle to point then convert to degrees
    float theta = degrees(atan(point.y, point.x)); 

    // Each color component is just a colorWheelValue function at a different offset
 	vec3 baseColor =  vec3(
        colorWheelValue(theta + 240.0),
        colorWheelValue(theta),
        colorWheelValue(theta + 120.0));
    
    // Layer color based on log of magnitude, and
    // darken color for magnitudes less than 1
    float magnitude = length(point);
    float layer = mod(log(magnitude) + layerShift * iTime / 2.0, 1.0); // Calculate layer percentage
    layer = mix(1.0, layer, layerIntensity); // Transform based on layer intensity
    return baseColor * clamp(magnitude, 0.0, 1.0) * layer;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float minDimension = min(iResolution.x, iResolution.y);
    
    vec3 color = vec3(0.0);
    
    // Supersample
    for (int j = 0; j < SUPERSAMPLE; j++) {
        for (int i = 0; i < SUPERSAMPLE; i++) {
         	vec2 screenCoord = gl_FragCoord.xy + offset + increment * vec2(float(i), float(j));
            
            // Transform screen coord so minimum dimension is on interval 
            vec2 coord = (2.0 * screenCoord - iResolution.xy) / minDimension;

            // Transform coord to account for user-defined scale and center
            coord = coord*SCALE + CENTER;

            // The output of the complex equation f(z)
            vec2 fz = f(coord);

            color += getColorFromPoint(fz);
        }
    }
    
    // Average the samples
    color /= float(samples);

    // Output to screen
    gl_FragColor = vec4(color, 1.0);
}

// *** Complex operation implementations ***

// c1 * c2
vec2 complexMultiply(vec2 c1, vec2 c2) {
    return vec2(
    	c1.x*c2.x - c1.y*c2.y,
    	c1.x*c2.y + c1.y*c2.x);
}

// c1 / c2
vec2 complexDivide(vec2 c1, vec2 c2) {
    // c1/(a + bi) = c1*(a - bi)/(a^2 + b^2)
    vec2 numerator = complexMultiply(c1, vec2(c2.x, -c2.y));
    float denominator = c2.x*c2.x + c2.y*c2.y;
    
    return numerator / denominator;
}

// f / c
vec2 complexDivide(float f, vec2 c) {
 	// f/(a + bi) = f*(a - bi)/(a^2 + b^2)
    vec2 numerator = f * vec2(c.x, -c.y);
    float denominator = c.x*c.x + c.y*c.y;
    
    return numerator / denominator;
}

// log(c)
vec2 complexLog(vec2 c) {
	// ln(c) = ln(||c||) + i*arg(c)
    return vec2(0.5 * log(dot(c, c)), atan(c.y, c.x));
}

// e^c
vec2 complexExp(vec2 c) {
    // e^(a + bi) = e^a * (cos b + i*sin b)
    return exp(c.x) * vec2(cos(c.y), sin(c.y));
}

// c^exponent
vec2 complexPow(vec2 c, vec2 exponent) {
 	// c^exponent = e^(exponent * ln(c))
    return complexExp(complexMultiply(exponent, complexLog(c)));
}

// sin(c)
vec2 complexSin(vec2 c) {
    // sin(a + bi) = sin a * cosh b + i*cos a * sinh b
    return vec2(sin(c.x) * cosh(c.y), cos(c.x) * sinh(c.y));
}

// cos(c)
vec2 complexCos(vec2 c) {
    // cos(a + bi) = cos a * cosh b + i*sin a * sinh b
    return vec2(cos(c.x) * cosh(c.y), sin(c.x) * sinh(c.y));
}

// tan(c)
vec2 complexTan(vec2 c) {
    // tan(a + bi) = (sin 2a + i*sinh 2b) / (cos 2a + cosh 2b)
    return vec2(sin(2.0*c.x), sinh(2.0*c.y)) / (cos(2.0*c.x) + cosh(2.0*c.y));
}

    // Output to screen
   // gl_FragColor = vec4(color, 1.0);
